﻿#nullable enable
namespace Hims.Api.Models.Account
{
    using System.Collections.Generic;
    using Shared.Library.Enums;

    /// <summary>
    /// The login OTP request.
    /// </summary>
    public class LoginOTPRequest
    {
        /// <summary>
        /// Gets or sets the email/mobile.
        /// </summary>
        public string Username { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the account types.
        /// </summary>
        public IEnumerable<AccountType> AccountTypes { get; set; } = new List<AccountType>();

        /// <summary>
        /// Gets or sets the device type.
        /// </summary>
        public DeviceType DeviceType { get; set; }

        /// <summary>
        /// Gets or sets the device key.
        /// </summary>
        public string? DeviceToken { get; set; }

        /// <summary>
        /// Gets or sets the device ID.
        /// </summary>
        public string? DeviceId { get; set; }

        /// <summary>
        /// Gets or sets the account ID.
        /// </summary>
        public int? AccountId { get; set; }

        public int? PatientId { get; set; }
    }
}
